-- Trigger ab2__a_iu__termination_auto
-- Zurückschreiben der Terminierungszeiten von den AGen zur ABK bei automatischer Terminierung.
-- aus 0200 Tables\J abk.sql
CREATE OR REPLACE FUNCTION ab2__a_iu__termination_auto() RETURNS TRIGGER AS $$
  DECLARE
      _startdate  timestamp;
      _prefix     varchar = format( 'ab2__a_iu__termination_auto ABK %L, AG %L -', new.a2_ab_ix, new.a2_n );
      _start_time time;
      _end_time   time;
      _loglevel   integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

  BEGIN --ACHTUNG: nur wenn nicht aus Terminierung kommend! siehe WHEN in Trigger => execution_flag__isset( _flagname => 'inTerminierung' )

      _start_time := clock_timestamp()::time;
      --
      IF _loglevel >= 5 THEN
          RAISE NOTICE '% ENTER:%;', _prefix, _start_time;
      END IF;
      --
      PERFORM scheduling.abk__at_et__from__ab2__sync( new.a2_ab_ix ); -- darin Logging
      --
      _end_time := clock_timestamp()::time;
      --
      IF _loglevel >= 5 THEN
          RAISE NOTICE '% Duration:%, Start:%, Leave:%', _prefix, _end_time - _start_time, _start_time, _end_time;
      END IF;

      RETURN new;

  END $$ LANGUAGE plpgsql;
--
  DROP TRIGGER IF EXISTS ab2__a_iu__termination_auto ON ab2;
  CREATE TRIGGER ab2__a_iu__termination_auto
      AFTER INSERT OR UPDATE
      OF a2_at, a2_et
      ON ab2
      FOR EACH ROW
      WHEN ( TSystem.execution_flag__isset__cascade_save( _flagname => 'inTerminierung' ) )   -- Während automatischer Terminierung ausführen -- TODO Doku: WIESO Während? Eigentlich sollte bei automatischer Terminierung wo sync_ab2 auch sync_abk. so ist das doch recht instransparent? Ich hätte eher gedacht die Terminierung schaltet das ab, und manuelles murxen macht dies automatisch
      EXECUTE PROCEDURE ab2__a_iu__termination_auto();
--